<?php
/*
Plugin Name: Arabesque Twitter Feed
Description: Plugin that adds Twitter feed functionality to our theme
Author: Mikado Themes
Version: 1.0.4
*/

define( 'ARABESQUE_TWITTER_FEED_VERSION', '1.0.4' );
define( 'ARABESQUE_TWITTER_ABS_PATH', dirname( __FILE__ ) );
define( 'ARABESQUE_TWITTER_REL_PATH', dirname( plugin_basename( __FILE__ ) ) );
define( 'ARABESQUE_TWITTER_URL_PATH', plugin_dir_url( __FILE__ ) );
define( 'ARABESQUE_TWITTER_ASSETS_PATH', ARABESQUE_TWITTER_ABS_PATH . '/assets' );
define( 'ARABESQUE_TWITTER_ASSETS_URL_PATH', ARABESQUE_TWITTER_URL_PATH . 'assets' );
define( 'ARABESQUE_TWITTER_SHORTCODES_PATH', ARABESQUE_TWITTER_ABS_PATH . '/shortcodes' );
define( 'ARABESQUE_TWITTER_SHORTCODES_URL_PATH', ARABESQUE_TWITTER_URL_PATH . 'shortcodes' );

include_once 'load.php';

if ( ! function_exists( 'arabesque_twitter_theme_installed' ) ) {
	/**
	 * Checks whether theme is installed or not
	 * @return bool
	 */
	function arabesque_twitter_theme_installed() {
		return defined( 'MIKADO_ROOT' );
	}
}

if ( ! function_exists( 'arabesque_twitter_feed_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function arabesque_twitter_feed_text_domain() {
		load_plugin_textdomain( 'arabesque-twitter-feed', false, ARABESQUE_TWITTER_REL_PATH . '/languages' );
	}

	add_action( 'plugins_loaded', 'arabesque_twitter_feed_text_domain' );
}
