<?php

if ( ! function_exists( 'arabesque_mikado_footer_options_map' ) ) {
	function arabesque_mikado_footer_options_map() {

		arabesque_mikado_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'arabesque' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = arabesque_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'arabesque' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		arabesque_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'arabesque' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'arabesque' ),
				'parent'        => $footer_panel
			)
		);

		arabesque_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'uncovering_footer',
				'default_value' => 'no',
				'label'         => esc_html__( 'Uncovering Footer', 'arabesque' ),
				'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'arabesque' ),
				'parent'        => $footer_panel,
			)
		);

		arabesque_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'arabesque' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'arabesque' ),
				'parent'        => $footer_panel,
			)
		);

		$show_footer_top_container = arabesque_mikado_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		arabesque_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'arabesque' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'arabesque' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
					'3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		arabesque_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'arabesque' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'arabesque' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'arabesque' ),
					'left'   => esc_html__( 'Left', 'arabesque' ),
					'center' => esc_html__( 'Center', 'arabesque' ),
					'right'  => esc_html__( 'Right', 'arabesque' )
				),
				'parent'        => $show_footer_top_container,
			)
		);

		arabesque_mikado_add_admin_field(
			array(
				'name'        => 'footer_top_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'arabesque' ),
				'description' => esc_html__( 'Set background color for top footer area', 'arabesque' ),
				'parent'      => $show_footer_top_container
			)
		);

		arabesque_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'arabesque' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'arabesque' ),
				'parent'        => $footer_panel,
			)
		);

		$show_footer_bottom_container = arabesque_mikado_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		arabesque_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '6 6',
				'label'         => esc_html__( 'Footer Bottom Columns', 'arabesque' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'arabesque' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container,
			)
		);

		arabesque_mikado_add_admin_field(
			array(
				'name'        => 'footer_bottom_background_color',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'arabesque' ),
				'description' => esc_html__( 'Set background color for bottom footer area', 'arabesque' ),
				'parent'      => $show_footer_bottom_container
			)
		);
	}

	add_action( 'arabesque_mikado_action_options_map', 'arabesque_mikado_footer_options_map', 11 );
}