<?php

if ( ! function_exists( 'arabesque_mikado_reset_options_map' ) ) {
	/**
	 * Reset options panel
	 */
	function arabesque_mikado_reset_options_map() {
		
		arabesque_mikado_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__( 'Reset', 'arabesque' ),
				'icon'  => 'fa fa-retweet'
			)
		);
		
		$panel_reset = arabesque_mikado_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__( 'Reset', 'arabesque' )
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'reset_to_defaults',
				'default_value' => 'no',
				'label'         => esc_html__( 'Reset to Defaults', 'arabesque' ),
				'description'   => esc_html__( 'This option will reset all Select Options values to defaults', 'arabesque' ),
				'parent'        => $panel_reset
			)
		);
	}
	
	add_action( 'arabesque_mikado_action_options_map', 'arabesque_mikado_reset_options_map', 100 );
}