<?php

class ArabesqueMikadoVerticalSeparatorWidget extends ArabesqueMikadoWidget {
	public function __construct() {
		parent::__construct(
			'mkdf_vertical_separator_widget',
			esc_html__( 'Arabesque Vertical Separator Widget', 'arabesque-core' ),
			array( 'description' => esc_html__( 'Add a vertical separator element to your widget areas', 'arabesque-core' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Holder Height', 'arabesque-core' ),
				'options' => array(
					'full-height'   => esc_html__( 'Full Height', 'arabesque-core' ),
					'custom-height' => esc_html__( 'Custom Height', 'arabesque-core' ),
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'align',
				'title'   => esc_html__( 'Vertical Align', 'arabesque-core' ),
				'options' => array(
					'middle' => esc_html__( 'Middle', 'arabesque-core' ),
					'top'   => esc_html__( 'Top', 'arabesque-core' ),
					'bottom'  => esc_html__( 'Bottom', 'arabesque-core' )
				)
			),
			array(
				'type'  => 'textfield',
				'name'  => 'height',
				'title' => esc_html__( 'Height (px or %)', 'arabesque-core' ),
				'description' => esc_html__('The percentage aparabesques only if the \'Full Holder Height\' is selected','arabesque-core')
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'border_style',
				'title'   => esc_html__( 'Style', 'arabesque-core' ),
				'options' => array(
					'solid'  => esc_html__( 'Solid', 'arabesque-core' ),
					'dashed' => esc_html__( 'Dashed', 'arabesque-core' ),
					'dotted' => esc_html__( 'Dotted', 'arabesque-core' )
				)
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'arabesque-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'thickness',
				'title' => esc_html__( 'Thickness (px)', 'arabesque-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'left_margin',
				'title' => esc_html__( 'Left Margin (px)', 'arabesque-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'right_margin',
				'title' => esc_html__( 'Right Margin (px)', 'arabesque-core' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}

		$holder_class = '';

		if ($instance['type'] == 'full-height') {
			$holder_class = 'mkdf-vertical-separator-full-height';
		}

		$style = array();

		if ($instance['align'] !== '') {
			$style[] = 'vertical-align:'.$instance['align'];
		}

		if ($instance['height'] !== '') {
			if (arabesque_mikado_string_ends_with($instance['height'],'%')){
				$height = $instance['height'];
			} else {
				$height = arabesque_mikado_filter_px($instance['height']).'px';
			}
			$style[] = 'height:'.$height;
		}

		if ($instance['border_style'] !== '') {
			$style[] = 'border-left-style:'.$instance['border_style'];
		}

		if ($instance['color'] !== '') {
			$style[] = 'border-color:'.$instance['color'];
		}

		if ($instance['thickness'] !== '') {
			$style[] = 'border-width:'.arabesque_mikado_filter_px($instance['thickness']).'px';
		}

		if ($instance['left_margin'] !== '') {
			$style[] = 'margin-left:'.arabesque_mikado_filter_px($instance['left_margin']).'px';
		}

		if ($instance['right_margin'] !== '') {
			$style[] = 'margin-right:'.arabesque_mikado_filter_px($instance['right_margin']).'px';
		}

		$html = '';
		
		$html .= '<div class="widget mkdf-vertical-separator-widget '.esc_attr($holder_class).'">';
		$html .= '<span class="mkdf-vsw-height-holder"></span>';
		$html .= '<span class="mkdf-vsw" '.arabesque_mikado_get_inline_style($style).'></span>';
		$html .= '</div>';

		echo wp_kses_post($html);
	}
}