<?php

if ( ! function_exists( 'arabesque_mikado_load_widget_class' ) ) {
	/**
	 * Loades widget class file.
	 */
	function arabesque_mikado_load_widget_class() {
		include_once ARABESQUE_CORE_ABS_PATH . '/widgets/lib/widget-class.php';
	}

	add_action( 'arabesque_mikado_action_before_options_map', 'arabesque_mikado_load_widget_class' );
}

if ( ! function_exists( 'arabesque_mikado_load_widgets' ) ) {
	/**
	 * Loades all widgets by going through all folders that are placed directly in widgets folder
	 * and loads load.php file in each. Hooks to arabesque_mikado_action_after_options_map action
	 */
	function arabesque_mikado_load_widgets() {
		foreach ( glob( ARABESQUE_CORE_ABS_PATH . '/widgets/*/load.php' ) as $widget_load ) {
			include_once $widget_load;
		}

		include_once ARABESQUE_CORE_ABS_PATH . '/widgets/lib/widget-loader.php';
	}

	add_action( 'arabesque_mikado_action_before_options_map', 'arabesque_mikado_load_widgets' );
}