<?php

class ArabesqueMikadoButtonWidget extends ArabesqueMikadoWidget {
	public function __construct() {
		parent::__construct(
			'mkdf_button_widget',
			esc_html__( 'Arabesque Button Widget', 'arabesque-core' ),
			array( 'description' => esc_html__( 'Add button element to widget areas', 'arabesque-core' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'arabesque-core' ),
				'options' => array(
					'solid'   => esc_html__( 'Solid', 'arabesque-core' ),
					'outline' => esc_html__( 'Outline', 'arabesque-core' ),
					'simple'  => esc_html__( 'Simple', 'arabesque-core' )
				)
			),
			array(
				'type'        => 'dropdown',
				'name'        => 'size',
				'title'       => esc_html__( 'Size', 'arabesque-core' ),
				'options'     => array(
					'small'  => esc_html__( 'Small', 'arabesque-core' ),
					'medium' => esc_html__( 'Medium', 'arabesque-core' ),
					'large'  => esc_html__( 'Large', 'arabesque-core' ),
					'huge'   => esc_html__( 'Huge', 'arabesque-core' )
				),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'arabesque-core' )
			),
			array(
				'type'    => 'textfield',
				'name'    => 'text',
				'title'   => esc_html__( 'Text', 'arabesque-core' ),
				'default' => esc_html__( 'Button Text', 'arabesque-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'link',
				'title' => esc_html__( 'Link', 'arabesque-core' )
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'target',
				'title'   => esc_html__( 'Link Target', 'arabesque-core' ),
				'options' => arabesque_mikado_get_link_target_array()
			),
            array(
                'type'        => 'dropdown',
                'name'        => 'enable_underline',
                'title'       => esc_html__( 'Enable Underline', 'arabesque-core' ),
                'options'     => array(
                    esc_html__('no','arabesque-core') => 'No',
                    esc_html__('yes','arabesque-core') => 'Yes'
                ),
                'default' => esc_html__( 'no', 'arabesque-core' )
            ),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'arabesque-core' )
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'hover_color',
				'title' => esc_html__( 'Hover Color', 'arabesque-core' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'background_color',
				'title'       => esc_html__( 'Background Color', 'arabesque-core' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'arabesque-core' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_background_color',
				'title'       => esc_html__( 'Hover Background Color', 'arabesque-core' ),
				'description' => esc_html__( 'This option is only available for solid button type', 'arabesque-core' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'border_color',
				'title'       => esc_html__( 'Border Color', 'arabesque-core' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'arabesque-core' )
			),
			array(
				'type'        => 'colorpicker',
				'name'        => 'hover_border_color',
				'title'       => esc_html__( 'Hover Border Color', 'arabesque-core' ),
				'description' => esc_html__( 'This option is only available for solid and outline button type', 'arabesque-core' )
			),
			array(
				'type'        => 'textfield',
				'name'        => 'margin',
				'title'       => esc_html__( 'Margin', 'arabesque-core' ),
				'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'arabesque-core' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		$params = '';
		
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		// Filter out all empty params
		$instance = array_filter( $instance, function ( $array_value ) {
			return trim( $array_value ) != '';
		} );
		
		// Default values
		if ( ! isset( $instance['text'] ) ) {
			$instance['text'] = 'Button Text';
		}
		
		// Generate shortcode params
		foreach ( $instance as $key => $value ) {
			$params .= " $key='$value' ";
		}
		
		echo '<div class="widget mkdf-button-widget">';
			echo do_shortcode( "[mkdf_button $params]" ); // XSS OK
		echo '</div>';
	}
}