<?php
namespace ArabesqueCore\CPT\Shortcodes\WorkingHours;

use ArabesqueCore\Lib;

class WorkingHours implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'mkdf_working_hours';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Working Hours', 'arabesque-core' ),
					'base'                      => $this->base,
					'category'                  => esc_html__( 'By ARABESQUE', 'arabesque-core' ),
					'icon'                      => 'icon-wpb-working-hours extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'arabesque-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'arabesque-core' )
						),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'holder_alignment',
                            'heading'     => esc_html__( 'Holder alignment', 'arabesque-core' ),
                            'value'       => array(
                                esc_html__( 'Center', 'arabesque-core' ) => 'center',
                                esc_html__( 'Left', 'arabesque-core' )   => 'left',
                                esc_html__( 'Right', 'arabesque-core' )  => 'right'
                            ),
                            'save_always' => true,
                            'dependency'  => array( 'element' => 'text', 'not_empty' => true ),
                            'group'       => esc_html__( 'Text Style', 'arabesque-core' )
                        ),
						array(
							'type'        => 'textfield',
							'param_name'  => 'title',
							'heading'     => esc_html__( 'Title', 'arabesque-core' ),
							'admin_label' => true
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'title_tag',
							'heading'     => esc_html__( 'Title Tag', 'arabesque-core' ),
							'value'       => array_flip( arabesque_mikado_get_title_tag( true ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'title', 'not_empty' => true ),
							'group'       => esc_html__( 'Title Style', 'arabesque-core' )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'title_color',
							'heading'    => esc_html__( 'Title Color', 'arabesque-core' ),
							'dependency' => array( 'element' => 'title', 'not_empty' => true ),
							'group'      => esc_html__( 'Title Style', 'arabesque-core' )
						),
						array(
							'type'       => 'textarea',
							'param_name' => 'text',
							'heading'    => esc_html__( 'Text', 'arabesque-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'text_tag',
							'heading'     => esc_html__( 'Text Tag', 'arabesque-core' ),
							'value'       => array_flip( arabesque_mikado_get_title_tag( true, array( 'p' => 'p', 'span' => 'span' ) ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'text', 'not_empty' => true ),
							'group'       => esc_html__( 'Text Style', 'arabesque-core' )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'text_color',
							'heading'    => esc_html__( 'Text Color', 'arabesque-core' ),
							'dependency' => array( 'element' => 'text', 'not_empty' => true ),
							'group'      => esc_html__( 'Text Style', 'arabesque-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'text_font_size',
							'heading'    => esc_html__( 'Text Font Size (px)', 'arabesque-core' ),
							'dependency' => array( 'element' => 'text', 'not_empty' => true ),
							'group'      => esc_html__( 'Text Style', 'arabesque-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'text_line_height',
							'heading'    => esc_html__( 'Text Line Height (px)', 'arabesque-core' ),
							'dependency' => array( 'element' => 'text', 'not_empty' => true ),
							'group'      => esc_html__( 'Text Style', 'arabesque-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'text_font_weight',
							'heading'     => esc_html__( 'Text Font Weight', 'arabesque-core' ),
							'value'       => array_flip( arabesque_mikado_get_font_weight_array( true ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'text', 'not_empty' => true ),
							'group'       => esc_html__( 'Text Style', 'arabesque-core' )
						),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'text_transform',
                            'heading'     => esc_html__( 'Text Transform', 'arabesque-core' ),
                            'value'       => array_flip( arabesque_mikado_get_text_transform_array( true ) ),
                            'save_always' => true,
                            'dependency'  => array( 'element' => 'text', 'not_empty' => true ),
                            'group'       => esc_html__( 'Text Style', 'arabesque-core' )
                        ),
						array(
							'type'       => 'textfield',
							'param_name' => 'text_margin',
							'heading'    => esc_html__( 'Text Top Margin (px)', 'arabesque-core' ),
							'dependency' => array( 'element' => 'text', 'not_empty' => true ),
							'group'      => esc_html__( 'Text Style', 'arabesque-core' )
						),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'button_text',
                            'heading'     => esc_html__( 'Button Text', 'arabesque-core' ),
                            'value'       => '',
                            'save_always' => true,
                        ),
                        array(
                            'type'       => 'textfield',
                            'param_name' => 'link',
                            'heading'    => esc_html__( 'Button Link', 'arabesque-core' ),
                            'dependency' => array( 'element' => 'button_text', 'not_empty' => true )
                        ),
                        array(
                            'type'       => 'colorpicker',
                            'param_name' => 'hover_color',
                            'heading'    => esc_html__( 'Button Hover Color', 'arabesque-core' ),
                            'dependency' => array( 'element' => 'button_text', 'not_empty' => true ),
                            'group'      => esc_html__( 'Button Style', 'arabesque-core' )
                        ),
                        array(
                            'type'       => 'colorpicker',
                            'param_name' => 'hover_background_color',
                            'heading'    => esc_html__( 'Button Hover Background Color', 'arabesque-core' ),
                            'dependency' => array( 'element' => 'button_text', 'not_empty' => true ),
                            'group'      => esc_html__( 'Button Style', 'arabesque-core' )
                        ),
                        array(
                            'type'       => 'colorpicker',
                            'param_name' => 'hover_border_color',
                            'heading'    => esc_html__( 'Button Hover Border Color', 'arabesque-core' ),
                            'dependency' => array( 'element' => 'button_text', 'not_empty' => true ),
                            'group'      => esc_html__( 'Button Style', 'arabesque-core' )
                        )
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'              => '',
			'holder_alignment'          => 'center',
			'title'                     => '',
			'title_tag'                 => 'h2',
			'title_color'               => '',
			'text'                      => '',
			'text_tag'                  => 'h4',
			'text_color'                => '',
			'text_font_size'            => '',
			'text_line_height'          => '',
			'text_font_weight'          => '',
            'text_transform'            => '',
			'text_margin'               => '',
            'button_text'               => esc_html__( 'DISCOVER', 'arabesque-core' ),
            'link'                      => '',
            'button_type'               => 'solid',
            'hover_color'               => '',
            'hover_background_color'    => '',
            'hover_border_color'        => ''
		);
		$params = shortcode_atts( $args, $atts );

		$params['holder_classes']           = $this->getHolderClasses( $params, $args );
		$params['holder_styles']            = $this->getHolderStyles( $params );
		$params['title_tag']                = ! empty( $params['title_tag'] ) ? $params['title_tag'] : $args['title_tag'];
		$params['title_styles']             = $this->getTitleStyles( $params );
		$params['text_tag']                 = ! empty( $params['text_tag'] ) ? $params['text_tag'] : $args['text_tag'];
		$params['text_styles']              = $this->getTextStyles( $params );
		$params['button_text']              = ! empty( $params['button_text'] ) ? $params['button_text'] : $args['button_text'];
        $params['hover_color']              = ! empty( $params['hover_color'] ) ? $params['hover_color'] : $args['hover_color'];
        $params['hover_background_color']   = ! empty( $params['hover_background_color'] ) ? $params['hover_background_color'] : $args['hover_background_color'];
        $params['hover_border_color']       = ! empty( $params['hover_border_color'] ) ? $params['hover_border_color'] : $args['hover_border_color'];
		
		$html = arabesque_core_get_shortcode_module_template_part( 'templates/working-hours', 'working-hours', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params, $args ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		
		return implode( ' ', $holderClasses );
	}
	
	private function getHolderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['holder_alignment'] ) ) {
            $styles[] = 'text-align: ' . $params['holder_alignment'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['text_color'] ) ) {
			$styles[] = 'color: ' . $params['text_color'];
		}
		
		if ( ! empty( $params['text_font_size'] ) ) {
			$styles[] = 'font-size: ' . arabesque_mikado_filter_px( $params['text_font_size'] ) . 'px';
		}
		
		if ( ! empty( $params['text_line_height'] ) ) {
			$styles[] = 'line-height: ' . arabesque_mikado_filter_px( $params['text_line_height'] ) . 'px';
		}
		
		if ( ! empty( $params['text_font_weight'] ) ) {
			$styles[] = 'font-weight: ' . $params['text_font_weight'];
		}

        if ( ! empty( $params['text_transform'] ) ) {
            $styles[] = 'text-transform: ' . $params['text_transform'];
        }
		
		if ( $params['text_margin'] !== '' ) {
			$styles[] = 'margin-top: ' . arabesque_mikado_filter_px( $params['text_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}
}