(function ($) {
    'use strict';

    var iconWithText = {};
    mkdf.modules.iconWithText = iconWithText;

    iconWithText.mkdfInitIconWithText = mkdfInitIconWithText;


    iconWithText.mkdfOnDocumentReady = mkdfOnDocumentReady;

    $(document).ready(mkdfOnDocumentReady);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function mkdfOnDocumentReady() {
        mkdfInitIconWithText();
    }

    /*
     **	Init Icon w/ Text shortcode
     */
    function mkdfInitIconWithText() {
        var holder = $('.mkdf-iwt-svg-path.mkdf-iwt-svg-animation-yes');

        if (holder.length) {
            holder.each(function () {
                var type = $(this).data('animation-type'),
                    duration = $(this).data('animation-duration'),
                    durationDelay = '',
                    reverse = '',
                    strokeWidth = '',
                    strokeColor = '',
                    selector = '',
                    customStyle = '',
                    style = '';

                if (typeof $(this).data('animation-duration-delay') !== 'undefined') {
                    durationDelay = $(this).data('animation-duration-delay');
                }

                if (typeof $(this).data('animation-reverse') !== 'undefined') {
                    reverse = $(this).data('animation-reverse');
                }

                if (typeof $(this).data('stroke-width') !== 'undefined') {
                    strokeWidth = $(this).data('stroke-width');
                }

                if (typeof $(this).data('stroke-color') !== 'undefined') {
                    strokeColor = $(this).data('stroke-color');
                }

                new Vivus($(this).find('.mkdf-animated-svg').attr('id'), {
                    type: type,
                    duration: duration,
                    delay: durationDelay,
                    reverseStack: reverse,
                });

                if (strokeWidth > 0 || strokeColor.length) {
                    selector = '#' + $(this).find('.mkdf-animated-svg').attr('id') + ' path';

                    if (strokeWidth > 0) {
                        customStyle += 'stroke-width:' + strokeWidth + 'px;';
                    }

                    if (strokeColor.length) {
                        customStyle += 'stroke:' + strokeColor + ';';
                    }
                }

                if (customStyle.length) {
                    style = '<style type="text/css">' + selector + '{' + customStyle + '}</style>';
                }

                if (style.length) {
                    $('head').append(style);
                }
            });
        }
    }

})(jQuery);