<?php

if ( ! function_exists( 'arabesque_core_map_portfolio_settings_meta' ) ) {
	function arabesque_core_map_portfolio_settings_meta() {
		$meta_box = arabesque_mikado_create_meta_box( array(
			'scope' => 'portfolio-item',
			'title' => esc_html__( 'Portfolio Settings', 'arabesque-core' ),
			'name'  => 'portfolio_settings_meta_box'
		) );
		
		arabesque_mikado_create_meta_box_field( array(
			'name'        => 'mkdf_portfolio_single_template_meta',
			'type'        => 'select',
			'label'       => esc_html__( 'Portfolio Type', 'arabesque-core' ),
			'description' => esc_html__( 'Choose a default type for Single Project pages', 'arabesque-core' ),
			'parent'      => $meta_box,
			'options'     => array(
				''                  => esc_html__( 'Default', 'arabesque-core' ),
				'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'arabesque-core' ),
				'images'            => esc_html__( 'Portfolio Images', 'arabesque-core' ),
				'small-images'      => esc_html__( 'Portfolio Small Images', 'arabesque-core' ),
				'slider'            => esc_html__( 'Portfolio Slider', 'arabesque-core' ),
				'small-slider'      => esc_html__( 'Portfolio Small Slider', 'arabesque-core' ),
				'gallery'           => esc_html__( 'Portfolio Gallery', 'arabesque-core' ),
				'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'arabesque-core' ),
				'masonry'           => esc_html__( 'Portfolio Masonry', 'arabesque-core' ),
				'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'arabesque-core' ),
				'custom'            => esc_html__( 'Portfolio Custom', 'arabesque-core' ),
				'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'arabesque-core' )
			)
		) );
		
		/***************** Gallery Layout *****************/
		
		$gallery_type_meta_container = arabesque_mikado_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'mkdf_gallery_type_meta_container',
				'dependency' => array(
					'show' => array(
						'mkdf_portfolio_single_template_meta'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_single_gallery_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'arabesque-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'arabesque-core' ),
				'parent'        => $gallery_type_meta_container,
				'options'       => array(
					''      => esc_html__( 'Default', 'arabesque-core' ),
					'two'   => esc_html__( '2 Columns', 'arabesque-core' ),
					'three' => esc_html__( '3 Columns', 'arabesque-core' ),
					'four'  => esc_html__( '4 Columns', 'arabesque-core' )
				)
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_single_gallery_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'arabesque-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'arabesque-core' ),
				'default_value' => '',
				'options'       => arabesque_mikado_get_space_between_items_array( true ),
				'parent'        => $gallery_type_meta_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$masonry_type_meta_container = arabesque_mikado_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'mkdf_masonry_type_meta_container',
				'dependency' => array(
					'show' => array(
						'mkdf_masonry_type_meta_container'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_single_masonry_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'arabesque-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'arabesque-core' ),
				'parent'        => $masonry_type_meta_container,
				'options'       => array(
					''      => esc_html__( 'Default', 'arabesque-core' ),
					'two'   => esc_html__( '2 Columns', 'arabesque-core' ),
					'three' => esc_html__( '3 Columns', 'arabesque-core' ),
					'four'  => esc_html__( '4 Columns', 'arabesque-core' )
				)
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_single_masonry_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'arabesque-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'arabesque-core' ),
				'default_value' => '',
				'options'       => arabesque_mikado_get_space_between_items_array( true ),
				'parent'        => $masonry_type_meta_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_show_title_area_portfolio_single_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single portfolio page', 'arabesque-core' ),
				'parent'        => $meta_box,
				'options'       => arabesque_mikado_get_yes_no_select_array()
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'        => 'portfolio_info_top_padding',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Info Top Padding', 'arabesque-core' ),
				'description' => esc_html__( 'Set top padding for portfolio info elements holder. This option works only for Portfolio Images, Slider, Gallery and Masonry portfolio types', 'arabesque-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'        => 'portfolio_external_link',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio External Link', 'arabesque-core' ),
				'description' => esc_html__( 'Enter URL to link from Portfolio List page', 'arabesque-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_portfolio_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Featured Image', 'arabesque-core' ),
				'description' => esc_html__( 'Choose an image for Portfolio Lists shortcode where Hover Type option is Switch Featured Images', 'arabesque-core' ),
				'parent'      => $meta_box
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_masonry_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Fixed Proportion', 'arabesque-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is fixed', 'arabesque-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''                   => esc_html__( 'Default', 'arabesque-core' ),
					'small'              => esc_html__( 'Small', 'arabesque-core' ),
					'large-width'        => esc_html__( 'Large Width', 'arabesque-core' ),
					'large-height'       => esc_html__( 'Large Height', 'arabesque-core' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'arabesque-core' )
				)
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_portfolio_masonry_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Original Proportion', 'arabesque-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is original', 'arabesque-core' ),
				'default_value' => 'default',
				'parent'        => $meta_box,
				'options'       => array(
					'default'     => esc_html__( 'Default', 'arabesque-core' ),
					'large-width' => esc_html__( 'Large Width', 'arabesque-core' )
				)
			)
		);
		
		$all_pages = array();
		$pages     = get_pages();
		foreach ( $pages as $page ) {
			$all_pages[ $page->ID ] = $page->post_title;
		}
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'        => 'portfolio_single_back_to_link',
				'type'        => 'select',
				'label'       => esc_html__( '"Back To" Link', 'arabesque-core' ),
				'description' => esc_html__( 'Choose "Back To" page to link from portfolio Single Project page', 'arabesque-core' ),
				'parent'      => $meta_box,
				'options'     => $all_pages,
				'args'        => array(
					'select2' => true
				)
			)
		);
	}
	
	add_action( 'arabesque_mikado_action_meta_boxes_map', 'arabesque_core_map_portfolio_settings_meta', 41 );
}