<?php

class ArabesqueMikadoSeparatorWidget extends ArabesqueMikadoWidget {
	public function __construct() {
		parent::__construct(
			'mkdf_separator_widget',
			esc_html__( 'Arabesque Separator Widget', 'arabesque-core' ),
			array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'arabesque-core' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$this->params = array(
			array(
				'type'    => 'dropdown',
				'name'    => 'type',
				'title'   => esc_html__( 'Type', 'arabesque-core' ),
				'options' => array(
					'normal'     => esc_html__( 'Normal', 'arabesque-core' ),
					'full-width' => esc_html__( 'Full Width', 'arabesque-core' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'position',
				'title'   => esc_html__( 'Position', 'arabesque-core' ),
				'options' => array(
					'center' => esc_html__( 'Center', 'arabesque-core' ),
					'left'   => esc_html__( 'Left', 'arabesque-core' ),
					'right'  => esc_html__( 'Right', 'arabesque-core' )
				)
			),
			array(
				'type'    => 'dropdown',
				'name'    => 'border_style',
				'title'   => esc_html__( 'Style', 'arabesque-core' ),
				'options' => array(
					'solid'  => esc_html__( 'Solid', 'arabesque-core' ),
					'dashed' => esc_html__( 'Dashed', 'arabesque-core' ),
					'dotted' => esc_html__( 'Dotted', 'arabesque-core' )
				)
			),
			array(
				'type'  => 'colorpicker',
				'name'  => 'color',
				'title' => esc_html__( 'Color', 'arabesque-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'width',
				'title' => esc_html__( 'Width (px or %)', 'arabesque-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'thickness',
				'title' => esc_html__( 'Thickness (px)', 'arabesque-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'top_margin',
				'title' => esc_html__( 'Top Margin (px or %)', 'arabesque-core' )
			),
			array(
				'type'  => 'textfield',
				'name'  => 'bottom_margin',
				'title' => esc_html__( 'Bottom Margin (px or %)', 'arabesque-core' )
			)
		);
	}
	
	public function widget( $args, $instance ) {
		if ( ! is_array( $instance ) ) {
			$instance = array();
		}
		
		//prepare variables
		$params = '';
		
		//is instance empty?
		if ( is_array( $instance ) && count( $instance ) ) {
			//generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}
		}
		
		echo '<div class="widget mkdf-separator-widget">';
			echo do_shortcode( "[mkdf_separator $params]" ); // XSS OK
		echo '</div>';
	}
}