<?php

class ArabesqueMikadoSearchPostType extends ArabesqueMikadoWidget {
	public function __construct() {
		parent::__construct(
			'mkdf_search_post_type',
			esc_html__( 'Arabesque Search Post Type', 'arabesque-core' ),
			array( 'description' => esc_html__( 'Select post type that you want to be searched for', 'arabesque-core' ) )
		);
		
		$this->setParams();
	}
	
	protected function setParams() {
		$post_types = apply_filters( 'arabesque_mikado_filter_search_post_type_widget_params_post_type', array( 'post' => esc_html__( 'Post', 'arabesque-core' ) ) );
		
		$this->params = array(
			array(
				'type'        => 'dropdown',
				'name'        => 'post_type',
				'title'       => esc_html__( 'Post Type', 'arabesque-core' ),
				'description' => esc_html__( 'Choose post type that you want to be searched for', 'arabesque-core' ),
				'options'     => $post_types
			)
		);
	}
	
	public function widget( $args, $instance ) {
		$search_type_class = 'mkdf-search-post-type';
		$post_type         = $instance['post_type'];
		?>
		
		<div class="widget mkdf-search-post-type-widget">
			<div data-post-type="<?php echo esc_attr( $post_type ); ?>" <?php arabesque_mikado_class_attribute( $search_type_class ); ?>>
				<input class="mkdf-post-type-search-field" value="" placeholder="<?php esc_attr_e( 'Search here', 'arabesque-core' ) ?>">
                <span aria-hidden="true" class="mkdf-search-icon">
                    <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="22px" height="22px" viewBox="0 0 22 22" enable-background="new 0 0 22 22" xml:space="preserve">
                        <path d="M15.389,14.544c1.105-1.307,1.777-2.994,1.777-4.836c0-4.136-3.365-7.5-7.5-7.5c-4.136,0-7.5,3.364-7.5,7.5
	c0,4.137,3.365,7.5,7.5,7.5c1.934,0,3.693-0.742,5.025-1.947l5.305,4.926l0.682-0.732L15.389,14.544z M9.667,16.208
	c-3.584,0-6.5-2.917-6.5-6.5c0-3.584,2.916-6.5,6.5-6.5c3.584,0,6.5,2.916,6.5,6.5C16.167,13.292,13.25,16.208,9.667,16.208z"></path>
                    </svg>
                </span>
				<i class="mkdf-search-loading fa fa-spinner fa-spin mkdf-hidden" aria-hidden="true"></i>
			</div>
			<div class="mkdf-post-type-search-results"></div>
		</div>
	<?php }
}