(function($) {
    'use strict';

    var imageWithText = {};
    mkdf.modules.imageWithText = imageWithText;

    imageWithText.mkdfInitImageWithText = mkdfInitImageWithText;

    imageWithText.mkdfOnDocumentReady = mkdfOnDocumentReady;
    imageWithText.mkdfOnWindowLoad = mkdfOnWindowLoad;

    $(document).ready(mkdfOnDocumentReady);
    $(window).on('load', mkdfOnWindowLoad);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function mkdfOnDocumentReady() {
    }

    /*
     All functions to be called on $(window).on('load', ) should be in this function
     */
    function mkdfOnWindowLoad() {
        mkdfInitImageWithText();
    }

    /*
     **	Horizontal progress bars shortcode
     */
    function mkdfInitImageWithText(){
        var imageWithText = $('.mkdf-image-with-text-holder.mkdf-iwt-appear-animation-yes');

        if(imageWithText.length){

            var showItem = function(item) {
                item
                    .addClass('mkdf-item-show')
                    .one(mkdf.transitionEnd, function() {
                        item.addClass('mkdf-item-shown');
                    });
            }

            var show = function (list) {
                var items = list.find('.mkdf-image-with-text-animation-holder'),
                    counter = 0,
                    delay = 0;

                    delay = list.data('animation-delay');
                    if (typeof list.data('animation-delay') !== 'undefined' && list.data('animation-delay') !== false) {
                        delay = list.data('animation-delay');
                    }

                items.appear(function(l) {
                    var item = $(this);

                    counter++;

                    item.css('transition-delay', delay+ 'ms');
                    showItem(item);
                }, {accX: 0, accY: mkdfGlobalVars.vars.mkdfElementAppearAmount});
            }

            imageWithText.each(function () {
                show($(this));
            });

        }
    }

})(jQuery);