<?php

if ( ! function_exists( 'arabesque_core_map_testimonials_meta' ) ) {
	function arabesque_core_map_testimonials_meta() {
		$testimonial_meta_box = arabesque_mikado_create_meta_box(
			array(
				'scope' => array( 'testimonials' ),
				'title' => esc_html__( 'Testimonial', 'arabesque-core' ),
				'name'  => 'testimonial_meta'
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_testimonial_title',
				'type'        => 'text',
				'label'       => esc_html__( 'Title', 'arabesque-core' ),
				'description' => esc_html__( 'Enter testimonial title', 'arabesque-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_testimonial_text',
				'type'        => 'text',
				'label'       => esc_html__( 'Text', 'arabesque-core' ),
				'description' => esc_html__( 'Enter testimonial text', 'arabesque-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_testimonial_author',
				'type'        => 'text',
				'label'       => esc_html__( 'Author', 'arabesque-core' ),
				'description' => esc_html__( 'Enter author name', 'arabesque-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		arabesque_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_testimonial_author_position',
				'type'        => 'text',
				'label'       => esc_html__( 'Author Position', 'arabesque-core' ),
				'description' => esc_html__( 'Enter author job position', 'arabesque-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
	}
	
	add_action( 'arabesque_mikado_action_meta_boxes_map', 'arabesque_core_map_testimonials_meta', 95 );
}