<?php

if ( ! function_exists( 'arabesque_mikado_portfolio_options_map' ) ) {
	function arabesque_mikado_portfolio_options_map() {
		
		arabesque_mikado_add_admin_page(
			array(
				'slug'  => '_portfolio',
				'title' => esc_html__( 'Portfolio', 'arabesque-core' ),
				'icon'  => 'fa fa-camera-retro'
			)
		);
		
		$panel_archive = arabesque_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Archive', 'arabesque-core' ),
				'name'  => 'panel_portfolio_archive',
				'page'  => '_portfolio'
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'        => 'portfolio_archive_number_of_items',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Items', 'arabesque-core' ),
				'description' => esc_html__( 'Set number of items for your portfolio list on archive pages. Default value is 12', 'arabesque-core' ),
				'parent'      => $panel_archive,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_archive_number_of_columns',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'arabesque-core' ),
				'default_value' => '4',
				'description'   => esc_html__( 'Set number of columns for your portfolio list on archive pages. Default value is 4 columns', 'arabesque-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'2' => esc_html__( '2 Columns', 'arabesque-core' ),
					'3' => esc_html__( '3 Columns', 'arabesque-core' ),
					'4' => esc_html__( '4 Columns', 'arabesque-core' ),
					'5' => esc_html__( '5 Columns', 'arabesque-core' )
				)
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_archive_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'arabesque-core' ),
				'description'   => esc_html__( 'Set space size between portfolio items for your portfolio list on archive pages. Default value is normal', 'arabesque-core' ),
				'default_value' => 'normal',
				'options'       => arabesque_mikado_get_space_between_items_array(),
				'parent'        => $panel_archive
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_archive_image_size',
				'type'          => 'select',
				'label'         => esc_html__( 'Image Proportions', 'arabesque-core' ),
				'default_value' => 'landscape',
				'description'   => esc_html__( 'Set image proportions for your portfolio list on archive pages. Default value is landscape', 'arabesque-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'full'      => esc_html__( 'Original', 'arabesque-core' ),
					'landscape' => esc_html__( 'Landscape', 'arabesque-core' ),
					'portrait'  => esc_html__( 'Portrait', 'arabesque-core' ),
					'square'    => esc_html__( 'Square', 'arabesque-core' )
				)
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_archive_item_layout',
				'type'          => 'select',
				'label'         => esc_html__( 'Item Style', 'arabesque-core' ),
				'default_value' => 'standard-shader',
				'description'   => esc_html__( 'Set item style for your portfolio list on archive pages. Default value is Standard - Shader', 'arabesque-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'standard-shader' => esc_html__( 'Standard - Shader', 'arabesque-core' ),
					'gallery-overlay' => esc_html__( 'Gallery - Overlay', 'arabesque-core' )
				)
			)
		);
		
		$panel = arabesque_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Single', 'arabesque-core' ),
				'name'  => 'panel_portfolio_single',
				'page'  => '_portfolio'
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_template',
				'type'          => 'select',
				'label'         => esc_html__( 'Portfolio Type', 'arabesque-core' ),
				'default_value' => 'small-images',
				'description'   => esc_html__( 'Choose a default type for Single Project pages', 'arabesque-core' ),
				'parent'        => $panel,
				'options'       => array(
					'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'arabesque-core' ),
					'images'            => esc_html__( 'Portfolio Images', 'arabesque-core' ),
					'small-images'      => esc_html__( 'Portfolio Small Images', 'arabesque-core' ),
					'slider'            => esc_html__( 'Portfolio Slider', 'arabesque-core' ),
					'small-slider'      => esc_html__( 'Portfolio Small Slider', 'arabesque-core' ),
					'gallery'           => esc_html__( 'Portfolio Gallery', 'arabesque-core' ),
					'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'arabesque-core' ),
					'masonry'           => esc_html__( 'Portfolio Masonry', 'arabesque-core' ),
					'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'arabesque-core' ),
					'custom'            => esc_html__( 'Portfolio Custom', 'arabesque-core' ),
					'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'arabesque-core' )
				)
			)
		);
		
		/***************** Gallery Layout *****************/
		
		$portfolio_gallery_container = arabesque_mikado_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_gallery_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'arabesque-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'arabesque-core' ),
				'parent'        => $portfolio_gallery_container,
				'options'       => array(
					'two'   => esc_html__( '2 Columns', 'arabesque-core' ),
					'three' => esc_html__( '3 Columns', 'arabesque-core' ),
					'four'  => esc_html__( '4 Columns', 'arabesque-core' )
				)
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'arabesque-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'arabesque-core' ),
				'default_value' => 'normal',
				'options'       => arabesque_mikado_get_space_between_items_array(),
				'parent'        => $portfolio_gallery_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$portfolio_masonry_container = arabesque_mikado_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_masonry_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'arabesque-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'arabesque-core' ),
				'parent'        => $portfolio_masonry_container,
				'options'       => array(
					'two'   => esc_html__( '2 Columns', 'arabesque-core' ),
					'three' => esc_html__( '3 Columns', 'arabesque-core' ),
					'four'  => esc_html__( '4 Columns', 'arabesque-core' )
				)
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'arabesque-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'arabesque-core' ),
				'default_value' => 'normal',
				'options'       => arabesque_mikado_get_space_between_items_array(),
				'parent'        => $portfolio_masonry_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		arabesque_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_portfolio_single',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single projects', 'arabesque-core' ),
				'parent'        => $panel,
				'options'       => array(
					''    => esc_html__( 'Default', 'arabesque-core' ),
					'yes' => esc_html__( 'Yes', 'arabesque-core' ),
					'no'  => esc_html__( 'No', 'arabesque-core' )
				),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_images',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Images', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for projects with images', 'arabesque-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_videos',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Videos', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects', 'arabesque-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_enable_categories',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Categories', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will enable category meta description on single projects', 'arabesque-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_date',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Date', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will enable date meta on single projects', 'arabesque-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_sticky_sidebar',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Sticky Side Text', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will make side text sticky on Single Project pages. This option works only for Full Width Images, Small Images, Small Gallery and Small Masonry portfolio types', 'arabesque-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_comments',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Show Comments', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will show comments on your page', 'arabesque-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_pagination',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Hide Pagination', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will turn off portfolio pagination functionality', 'arabesque-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		$container_navigate_category = arabesque_mikado_add_admin_container(
			array(
				'name'            => 'navigate_same_category_container',
				'parent'          => $panel,
				'dependency' => array(
					'hide' => array(
						'portfolio_single_hide_pagination'  => array(
							'yes'
						)
					)
				)
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'          => 'portfolio_single_nav_same_category',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Pagination Through Same Category', 'arabesque-core' ),
				'description'   => esc_html__( 'Enabling this option will make portfolio pagination sort through current category', 'arabesque-core' ),
				'parent'        => $container_navigate_category,
				'default_value' => 'no'
			)
		);
		
		arabesque_mikado_add_admin_field(
			array(
				'name'        => 'portfolio_single_slug',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Single Slug', 'arabesque-core' ),
				'description' => esc_html__( 'Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)', 'arabesque-core' ),
				'parent'      => $panel,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'arabesque_mikado_action_options_map', 'arabesque_mikado_portfolio_options_map', 15 );
}