<?php

if ( ! function_exists( 'arabesque_core_map_portfolio_meta' ) ) {
	function arabesque_core_map_portfolio_meta() {
		global $arabesque_mikado_Framework;
		
		$mkdf_pages = array();
		$pages      = get_pages();
		foreach ( $pages as $page ) {
			$mkdf_pages[ $page->ID ] = $page->post_title;
		}
		
		//Portfolio Images
		
		$mkdfPortfolioImages = new ArabesqueMikadoMetaBox( 'portfolio-item', esc_html__( 'Portfolio Images (multiple upload)', 'arabesque-core' ), '', '', 'portfolio_images' );
		$arabesque_mikado_Framework->mkdfMetaBoxes->addMetaBox( 'portfolio_images', $mkdfPortfolioImages );
		
		$mkdf_portfolio_image_gallery = new ArabesqueMikadoMultipleImages( 'mkdf-portfolio-image-gallery', esc_html__( 'Portfolio Images', 'arabesque-core' ), esc_html__( 'Choose your portfolio images', 'arabesque-core' ) );
		$mkdfPortfolioImages->addChild( 'mkdf-portfolio-image-gallery', $mkdf_portfolio_image_gallery );
		
		//Portfolio Single Upload Images/Videos 
		
		$mkdf_portfolio_images_videos = arabesque_mikado_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Portfolio Images/Videos (single upload)', 'arabesque-core' ),
				'name'  => 'mkdf_portfolio_images_videos'
			)
		);
		arabesque_mikado_add_repeater_field(
			array(
				'name'        => 'mkdf_portfolio_single_upload',
				'parent'      => $mkdf_portfolio_images_videos,
				'button_text' => esc_html__( 'Add Image/Video', 'arabesque-core' ),
				'fields'      => array(
					array(
						'type'        => 'select',
						'name'        => 'file_type',
						'label'       => esc_html__( 'File Type', 'arabesque-core' ),
						'options' => array(
							'image' => esc_html__('Image','arabesque-core'),
							'video' => esc_html__('Video','arabesque-core'),
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'single_image',
						'label'       => esc_html__( 'Image', 'arabesque-core' ),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'image'
							)
						)
					),
					array(
						'type'        => 'select',
						'name'        => 'video_type',
						'label'       => esc_html__( 'Video Type', 'arabesque-core' ),
						'options'	  => array(
							'youtube' => esc_html__('YouTube', 'arabesque-core'),
							'vimeo' => esc_html__('Vimeo', 'arabesque-core'),
							'self' => esc_html__('Self Hosted', 'arabesque-core'),
						),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'video'
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_id',
						'label'       => esc_html__( 'Video ID', 'arabesque-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => array('youtube','vimeo')
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_mp4',
						'label'       => esc_html__( 'Video mp4', 'arabesque-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'video_cover_image',
						'label'       => esc_html__( 'Video Cover Image', 'arabesque-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					)
				)
			)
		);
		
		//Portfolio Additional Sidebar Items
		
		$mkdfAdditionalSidebarItems = arabesque_mikado_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Additional Portfolio Sidebar Items', 'arabesque-core' ),
				'name'  => 'portfolio_properties'
			)
		);

		arabesque_mikado_add_repeater_field(
			array(
				'name'        => 'mkdf_portfolio_properties',
				'parent'      => $mkdfAdditionalSidebarItems,
				'button_text' => esc_html__( 'Add New Item', 'arabesque-core' ),
				'fields'      => array(
					array(
						'type'        => 'text',
						'name'        => 'item_title',
						'label'       => esc_html__( 'Item Title', 'arabesque-core' ),
					),
					array(
						'type'        => 'text',
						'name'        => 'item_text',
						'label'       => esc_html__( 'Item Text', 'arabesque-core' )
					),
					array(
						'type'        => 'text',
						'name'        => 'item_url',
						'label'       => esc_html__( 'Enter Full URL for Item Text Link', 'arabesque-core' )
					)
				)
			)
		);
	}
	
	add_action( 'arabesque_mikado_action_meta_boxes_map', 'arabesque_core_map_portfolio_meta', 40 );
}